//=============================================================================
// MS Puzzle Button.
//=============================================================================
class PuzzleButton extends DeusExDecoration;

enum EButtonType
{
	BT_Up,
	BT_Down
};

//var() name TriggerRecipiant;
var() int NumValue;
var() bool bSubtract;
var PuzzleCalc calc;
var() name CalcRecipiant;
var() EButtonType ButtonType;
var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

// WOW! What a mess.  I wish you could convert strings to names!
function SetSkin(EButtonType type, bool lit)
{
	switch (type)
	{
		case BT_Up:			if (lit)
							{
								Skin = Texture'Button1Tex2';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex1';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_Down:		if (lit)
							{
								Skin = Texture'Button1Tex4';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex3';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
	}
}

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin(ButtonType, bLit);

	if ( Level.NetMode != NM_Standalone )
		rpcLocation = Location;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	SetSkin(ButtonType, bLit);
	isPressed = False;
}

function CalculateValues(Actor Frobber)
{
local PuzzleCalc calc;
    foreach AllActors(class'PuzzleCalc', calc, CalcRecipiant)
    {

        if (!bSubtract)
        {
            calc.PuzzleCount += NumValue;
        }
        if (bSubtract)
        {
            calc.PuzzleCount -= NumValue;
        }
    }
}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local Pawn P;
local PuzzleCalc calc;

  P = Pawn(Frobber);

	if (!isPressed)
	{
		isPressed = True;
		PlaySound(buttonSound1, SLOT_None);
		SetSkin(ButtonType, !bLit);
		if (!bWaitForEvent)
			SetTimer(buttonLitTime, False);

		Super.Frob(Frobber, frobWith);
	}
        CalculateValues(Frobber);

    foreach AllActors(class'PuzzleCalc', calc, CalcRecipiant)
    {
      if ((!bSubtract && calc.PuzzleCount != calc.requiredcount && calc.PuzzleCount < 101))
      {
          P.ClientMessage("|p4Count has been modified by |p3+"$NumValue$", |p4count is now "$calc.PuzzleCount$", this counter requires a count of |p7"$calc.requiredcount$"");
      }
      else if ((!bSubtract && calc.PuzzleCount != calc.requiredcount && calc.PuzzleCount > 100))
      {
          P.ClientMessage("|p4Count has been modified by |p3+"$NumValue$", |p4count is now 100, this counter requires a count of |p7"$calc.requiredcount$"");
      }
      else if ((bSubtract && calc.PuzzleCount != calc.requiredcount && calc.PuzzleCount > -1))
      {
          P.ClientMessage("|p4Count has been modified by |p2-"$NumValue$", |p4count is now "$calc.PuzzleCount$", this counter requires a count of |p7"$calc.requiredcount$"");
      }
      else if ((bSubtract && calc.PuzzleCount != calc.requiredcount && calc.PuzzleCount < 0))
      {
          P.ClientMessage("|p4Count has been modified by |p2-"$NumValue$", |p4count is now 0, this counter requires a count of |p7"$calc.requiredcount$"");
      }
      else if (calc.PuzzleCount == calc.requiredcount)
      {
          P.ClientMessage("|p3Count has reached "$calc.requiredcount$", Puzzle Completed.");   
      }
    }                            
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     ButtonType=BT_Up
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     ItemName="Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
